"use strict";
exports.id = 5099;
exports.ids = [5099];
exports.modules = {

/***/ 38898:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Z": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = ({"src":"/_next/static/media/product.992a3f63.png","height":1000,"width":1000,"blurDataURL":"data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAAgAAAAIBAMAAAA2IaO4AAAAMFBMVEXFztnFztjEzdjEzdjEzdjEzdfDzdjDzdfEzNfDzNjDzNfDzNe6xdG6xNG5xNG4w9CIoVgcAAAAEHRSTlMwMDEyMzMzMzMzMzRTVlddIQK+CgAAADJJREFUeNpjqPBasoShZdUqLwYvZ5MlDKvkH65iWKV7aBWDlwPLEoYlq3d5MUR6LVkGADeyD5vQi0m1AAAAAElFTkSuQmCC","blurWidth":8,"blurHeight":8});

/***/ }),

/***/ 6189:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Z": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = ({"src":"/_next/static/media/sort.3a34c357.png","height":56,"width":59,"blurDataURL":"data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAAgAAAAICAYAAADED76LAAAAtElEQVR42jWOMQrCQBREp1X0HoKN4BHEA1hb2Es6KxEvIFa7hZAuq6KgWRtvkMbaLmIrYmslNuszJIHH/7N5O4mMS+eQmSQ9Q9s6L6hZlzYkHg6/NvErk/gn4rQUMvarWR/qYgkIA4QL8sw4HzMDOfAuF2FP3Y2ZQw86sOPSidn/C13MiDmEJrtgyWc21T+8se9l5YQssJxtC4H6D6GFcERYlEJMg68aHoQXUmAfg2DEhUiSfkzsjl3775SOAAAAAElFTkSuQmCC","blurWidth":8,"blurHeight":8});

/***/ }),

/***/ 17652:
/***/ ((module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.a(module, async (__webpack_handle_async_dependencies__, __webpack_async_result__) => { try {
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Z": () => (/* binding */ useGetBrandsList)
/* harmony export */ });
/* harmony import */ var api_manage_ApiRoutes__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(60274);
/* harmony import */ var react_query__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(61175);
/* harmony import */ var react_query__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react_query__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var helper_functions_getToken__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(61859);
/* harmony import */ var _MainApi__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(61176);
/* harmony import */ var _api_error_response_ErrorResponses__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(67759);
var __webpack_async_dependencies__ = __webpack_handle_async_dependencies__([_MainApi__WEBPACK_IMPORTED_MODULE_1__, _api_error_response_ErrorResponses__WEBPACK_IMPORTED_MODULE_2__]);
([_MainApi__WEBPACK_IMPORTED_MODULE_1__, _api_error_response_ErrorResponses__WEBPACK_IMPORTED_MODULE_2__] = __webpack_async_dependencies__.then ? (await __webpack_async_dependencies__)() : __webpack_async_dependencies__);





const getData = async ()=>{
    const userToken = (0,helper_functions_getToken__WEBPACK_IMPORTED_MODULE_3__/* .getToken */ .L)();
    const { data  } = await _MainApi__WEBPACK_IMPORTED_MODULE_1__/* ["default"].get */ .Z.get(api_manage_ApiRoutes__WEBPACK_IMPORTED_MODULE_4__/* .brand_list */ .WG);
    return data;
};
function useGetBrandsList(handleSuccess) {
    return (0,react_query__WEBPACK_IMPORTED_MODULE_0__.useQuery)("get-brandlists", ()=>getData(), {
        enabled: false,
        onSuccess: handleSuccess,
        onError: _api_error_response_ErrorResponses__WEBPACK_IMPORTED_MODULE_2__/* .onSingleErrorResponse */ .f$
    });
}

__webpack_async_result__();
} catch(e) { __webpack_async_result__(e); } });

/***/ }),

/***/ 63209:
/***/ ((module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.a(module, async (__webpack_handle_async_dependencies__, __webpack_async_result__) => { try {
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Z": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(20997);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _emotion_react__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(72805);
/* harmony import */ var _emotion_react__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_emotion_react__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _mui_material__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(65692);
/* harmony import */ var _mui_material__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_mui_material__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _mui_system__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(97986);
/* harmony import */ var _mui_system__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(_mui_system__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var i18next__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(22021);
/* harmony import */ var next_link__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(41664);
/* harmony import */ var next_link__WEBPACK_IMPORTED_MODULE_5___default = /*#__PURE__*/__webpack_require__.n(next_link__WEBPACK_IMPORTED_MODULE_5__);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(16689);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_6___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_6__);
/* harmony import */ var _assets_product_png__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(38898);
var __webpack_async_dependencies__ = __webpack_handle_async_dependencies__([i18next__WEBPACK_IMPORTED_MODULE_4__]);
i18next__WEBPACK_IMPORTED_MODULE_4__ = (__webpack_async_dependencies__.then ? (await __webpack_async_dependencies__)() : __webpack_async_dependencies__)[0];
/* eslint-disable @next/next/no-img-element */ 







const BrandCard = (props)=>{
    const { image , name , stock , id , horizontal , baseUrl , items_count  } = props;
    const theme = (0,_emotion_react__WEBPACK_IMPORTED_MODULE_1__.useTheme)();
    const imageUrl = image || _assets_product_png__WEBPACK_IMPORTED_MODULE_7__/* ["default"].src */ .Z.src;
    const tabScreen = (0,_mui_material__WEBPACK_IMPORTED_MODULE_2__.useMediaQuery)("(max-width: 991px)");
    return /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.Fragment, {
        children: /*#__PURE__*/ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)(_mui_system__WEBPACK_IMPORTED_MODULE_3__.Stack, {
            sx: {
                flexDirection: horizontal ? "column" : "row",
                textAlign: horizontal ? "center" : "",
                alignItems: "center",
                columnGap: "8px",
                position: "relative",
                transition: "all ease .3s",
                padding: "10px",
                borderRadius: "4px",
                ":hover": {
                    boxShadow: horizontal ? "" : theme.shadows[14]
                },
                a: {
                    position: "absolute",
                    inset: "0"
                }
            },
            children: [
                /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx((next_link__WEBPACK_IMPORTED_MODULE_5___default()), {
                    href: `/home?brand_id=${id}&data_type=brand`
                }),
                /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_mui_system__WEBPACK_IMPORTED_MODULE_3__.Stack, {
                    sx: {
                        maxWidth: horizontal ? {
                            xs: "200px"
                        } : {
                            xs: "45px",
                            md: "60px",
                            lg: "70px"
                        },
                        marginBottom: horizontal ? "10px" : "0",
                        img: {
                            maxWidth: "100%",
                            transition: "all ease .3s",
                            height: "unset",
                            objectFit: "contain",
                            aspectRatio: "1"
                        }
                    },
                    className: "brand-card-image",
                    children: /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx("img", {
                        src: imageUrl,
                        onError: (e)=>{
                            e.target.onerror = null; // Prevent infinite loop if fallback image also fails
                            e.target.src = _assets_product_png__WEBPACK_IMPORTED_MODULE_7__/* ["default"].src */ .Z.src; // Replace with your fallback image path
                        },
                        width: 200,
                        height: 200,
                        alt: "Brand"
                    })
                }),
                /*#__PURE__*/ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)(_mui_system__WEBPACK_IMPORTED_MODULE_3__.Box, {
                    width: horizontal ? "100%" : "0",
                    flexGrow: "1",
                    children: [
                        name && /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_mui_material__WEBPACK_IMPORTED_MODULE_2__.Typography, {
                            variant: "h6",
                            sx: {
                                fontSize: horizontal ? "18px" : {
                                    xs: "14px !important"
                                },
                                display: "-webkit-box",
                                WebkitBoxOrient: "vertical",
                                WebkitLineClamp: {
                                    xs: "1",
                                    sm: "2"
                                },
                                overflow: "hidden",
                                textOverflow: "ellipsis",
                                fontWeight: "600"
                            },
                            component: "h3",
                            children: name
                        }),
                        /*#__PURE__*/ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)(_mui_material__WEBPACK_IMPORTED_MODULE_2__.Typography, {
                            variant: "body2",
                            sx: {
                                opacity: "0.8"
                            },
                            component: "span",
                            children: [
                                items_count,
                                " ",
                                (0,i18next__WEBPACK_IMPORTED_MODULE_4__.t)("Products")
                            ]
                        })
                    ]
                })
            ]
        })
    });
};
BrandCard.propTypes = {};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (/*#__PURE__*/(0,react__WEBPACK_IMPORTED_MODULE_6__.memo)(BrandCard));

__webpack_async_result__();
} catch(e) { __webpack_async_result__(e); } });

/***/ }),

/***/ 85099:
/***/ ((module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.a(module, async (__webpack_handle_async_dependencies__, __webpack_async_result__) => { try {
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Z": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* unused harmony export CustomSkeleton */
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(20997);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _mui_material__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(65692);
/* harmony import */ var _mui_material__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_mui_material__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var components_typographies_H2__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(51829);
/* harmony import */ var i18next__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(22021);
/* harmony import */ var next_link__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(41664);
/* harmony import */ var next_link__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(next_link__WEBPACK_IMPORTED_MODULE_4__);
/* harmony import */ var styled_components_CustomStyles_style__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(45269);
/* harmony import */ var _emotion_react__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(72805);
/* harmony import */ var _emotion_react__WEBPACK_IMPORTED_MODULE_6___default = /*#__PURE__*/__webpack_require__.n(_emotion_react__WEBPACK_IMPORTED_MODULE_6__);
/* harmony import */ var _emotion_styled__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(81480);
/* harmony import */ var _emotion_styled__WEBPACK_IMPORTED_MODULE_7___default = /*#__PURE__*/__webpack_require__.n(_emotion_styled__WEBPACK_IMPORTED_MODULE_7__);
/* harmony import */ var api_manage_hooks_react_query_brands_useGetBrandsList__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(17652);
/* harmony import */ var components_container__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(28332);
/* harmony import */ var next_router__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(71853);
/* harmony import */ var next_router__WEBPACK_IMPORTED_MODULE_10___default = /*#__PURE__*/__webpack_require__.n(next_router__WEBPACK_IMPORTED_MODULE_10__);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(16689);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_11___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_11__);
/* harmony import */ var react_redux__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(6022);
/* harmony import */ var react_redux__WEBPACK_IMPORTED_MODULE_12___default = /*#__PURE__*/__webpack_require__.n(react_redux__WEBPACK_IMPORTED_MODULE_12__);
/* harmony import */ var redux_slices_brands__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(10186);
/* harmony import */ var sort_AtoZ__WEBPACK_IMPORTED_MODULE_14__ = __webpack_require__(72983);
/* harmony import */ var _BrandCard__WEBPACK_IMPORTED_MODULE_15__ = __webpack_require__(63209);
var __webpack_async_dependencies__ = __webpack_handle_async_dependencies__([components_typographies_H2__WEBPACK_IMPORTED_MODULE_2__, i18next__WEBPACK_IMPORTED_MODULE_3__, api_manage_hooks_react_query_brands_useGetBrandsList__WEBPACK_IMPORTED_MODULE_8__, sort_AtoZ__WEBPACK_IMPORTED_MODULE_14__, _BrandCard__WEBPACK_IMPORTED_MODULE_15__]);
([components_typographies_H2__WEBPACK_IMPORTED_MODULE_2__, i18next__WEBPACK_IMPORTED_MODULE_3__, api_manage_hooks_react_query_brands_useGetBrandsList__WEBPACK_IMPORTED_MODULE_8__, sort_AtoZ__WEBPACK_IMPORTED_MODULE_14__, _BrandCard__WEBPACK_IMPORTED_MODULE_15__] = __webpack_async_dependencies__.then ? (await __webpack_async_dependencies__)() : __webpack_async_dependencies__);
/* eslint-disable react-hooks/exhaustive-deps */ 















const CustomSkeleton = _emotion_styled__WEBPACK_IMPORTED_MODULE_7___default()(_mui_material__WEBPACK_IMPORTED_MODULE_1__.Skeleton)(({ theme  })=>({
        background: theme.palette.background.sklenton,
        maxWidth: "100%"
    }));
const Brands = ({ viewAll  })=>{
    const [sortBy, setSortBy] = (0,react__WEBPACK_IMPORTED_MODULE_11__.useState)("Default");
    const theme = (0,_emotion_react__WEBPACK_IMPORTED_MODULE_6__.useTheme)();
    const sliderRef = (0,react__WEBPACK_IMPORTED_MODULE_11__.useRef)();
    const tabScreen = (0,_mui_material__WEBPACK_IMPORTED_MODULE_1__.useMediaQuery)("(max-width: 991px)");
    const { brands: data  } = (0,react_redux__WEBPACK_IMPORTED_MODULE_12__.useSelector)((state)=>state?.brands);
    const { configData  } = (0,react_redux__WEBPACK_IMPORTED_MODULE_12__.useSelector)((state)=>state?.configData);
    const dispatch = (0,react_redux__WEBPACK_IMPORTED_MODULE_12__.useDispatch)();
    const handleSuccess = (response)=>{
        dispatch((0,redux_slices_brands__WEBPACK_IMPORTED_MODULE_13__/* .setBrands */ .dk)(response));
    };
    const { refetch , isLoading , isFetching  } = (0,api_manage_hooks_react_query_brands_useGetBrandsList__WEBPACK_IMPORTED_MODULE_8__/* ["default"] */ .Z)(handleSuccess);
    (0,react__WEBPACK_IMPORTED_MODULE_11__.useEffect)(()=>{
        if (!data) {
            refetch();
        }
    }, [
        data
    ]);
    const baseUrl = configData?.base_urls?.brand_image_url;
    const handleSortBy = (value)=>{
        setSortBy(value);
    };
    const [filteredData, setFilteredData] = (0,react__WEBPACK_IMPORTED_MODULE_11__.useState)(data);
    (0,react__WEBPACK_IMPORTED_MODULE_11__.useEffect)(()=>{
        if (data) {
            if (sortBy === "AtoZ") {
                setFilteredData([
                    ...data
                ].sort((a, b)=>a.name.localeCompare(b.name)));
            } else if (sortBy === "ZtoA") {
                setFilteredData([
                    ...data
                ].sort((a, b)=>b.name.localeCompare(a.name)));
            } else {
                setFilteredData(data);
            }
        }
    }, [
        data,
        sortBy
    ]);
    const router = (0,next_router__WEBPACK_IMPORTED_MODULE_10__.useRouter)();
    (0,react__WEBPACK_IMPORTED_MODULE_11__.useEffect)(()=>{
        if (!isLoading && !isFetching) {
            if (data?.length === 0 && viewAll) {
                router.push("/home");
            }
        }
    }, [
        isLoading,
        isFetching
    ]);
    // Page View
    if (viewAll) return /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.Fragment, {
        children: /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_mui_material__WEBPACK_IMPORTED_MODULE_1__.Box, {
            paddingBlock: "32px",
            children: /*#__PURE__*/ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)(components_container__WEBPACK_IMPORTED_MODULE_9__/* ["default"] */ .Z, {
                children: [
                    filteredData?.length > 0 ? /*#__PURE__*/ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)(_mui_material__WEBPACK_IMPORTED_MODULE_1__.Stack, {
                        direction: "row",
                        flexWrap: "wrap",
                        justifyContent: "space-between",
                        marginBottom: "30px",
                        paddingBottom: "20px",
                        borderBottom: `1px solid ${theme.palette.divider}`,
                        gap: 2,
                        children: [
                            /*#__PURE__*/ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)(_mui_material__WEBPACK_IMPORTED_MODULE_1__.Box, {
                                width: {
                                    xs: "100%",
                                    sm: "0"
                                },
                                flexGrow: "1",
                                children: [
                                    /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(components_typographies_H2__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .Z, {
                                        text: "Brands",
                                        textAlign: "left",
                                        component: "h2"
                                    }),
                                    /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_mui_material__WEBPACK_IMPORTED_MODULE_1__.Typography, {
                                        variant: "body1",
                                        children: (0,i18next__WEBPACK_IMPORTED_MODULE_3__.t)("Explore the Trusted and Trendsetting Brands")
                                    })
                                ]
                            }),
                            /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(sort_AtoZ__WEBPACK_IMPORTED_MODULE_14__/* ["default"] */ .Z, {
                                handleSortBy: handleSortBy,
                                sortBy: sortBy
                            })
                        ]
                    }) : isLoading || isFetching ? /*#__PURE__*/ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.Fragment, {
                        children: [
                            /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_mui_material__WEBPACK_IMPORTED_MODULE_1__.Skeleton, {
                                variant: "text",
                                width: "80px"
                            }),
                            /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_mui_material__WEBPACK_IMPORTED_MODULE_1__.Skeleton, {
                                variant: "text",
                                width: "60px"
                            })
                        ]
                    }) : "",
                    isLoading || isFetching ? /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.Fragment, {}) : filteredData?.length > 0 && /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_mui_material__WEBPACK_IMPORTED_MODULE_1__.Grid, {
                        container: true,
                        spacing: 2,
                        children: filteredData?.map((item, i)=>/*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_mui_material__WEBPACK_IMPORTED_MODULE_1__.Grid, {
                                item: true,
                                xs: 6,
                                md: 3,
                                children: /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(CustomBrandCard, {
                                    children: /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_BrandCard__WEBPACK_IMPORTED_MODULE_15__/* ["default"] */ .Z, {
                                        name: item?.name,
                                        image: item?.image_full_url,
                                        stock: item?.items_count,
                                        id: item?.id,
                                        baseUrl: baseUrl,
                                        items_count: item?.items_count
                                    })
                                })
                            }, item?.id))
                    })
                ]
            })
        })
    });
    // Section View
    return /*#__PURE__*/ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.Fragment, {
        children: [
            /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(styled_components_CustomStyles_style__WEBPACK_IMPORTED_MODULE_5__/* .CustomStackFullWidth */ .Xw, {
                justifyContent: "space-between",
                flexDirection: "row",
                children: data?.length > 0 ? /*#__PURE__*/ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.Fragment, {
                    children: [
                        /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(components_typographies_H2__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .Z, {
                            text: "Brands",
                            component: "h2"
                        }),
                        /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx((next_link__WEBPACK_IMPORTED_MODULE_4___default()), {
                            href: {
                                pathname: "/all-brands"
                            },
                            children: /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_mui_material__WEBPACK_IMPORTED_MODULE_1__.Button, {
                                variant: "text",
                                sx: {
                                    transition: "all ease 0.5s",
                                    textTransform: "capitalize",
                                    "&:hover": {
                                        letterSpacing: "0.03em"
                                    }
                                },
                                children: (0,i18next__WEBPACK_IMPORTED_MODULE_3__.t)("View all")
                            })
                        })
                    ]
                }) : isLoading || isFetching ? /*#__PURE__*/ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.Fragment, {
                    children: [
                        /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_mui_material__WEBPACK_IMPORTED_MODULE_1__.Skeleton, {
                            variant: "text",
                            width: "80px"
                        }),
                        /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_mui_material__WEBPACK_IMPORTED_MODULE_1__.Skeleton, {
                            variant: "text",
                            width: "60px"
                        })
                    ]
                }) : ""
            }),
            /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.Fragment, {
                children: /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_mui_material__WEBPACK_IMPORTED_MODULE_1__.Box, {
                    sx: {
                        paddingTop: "15px"
                    },
                    children: isLoading || isFetching ? /*#__PURE__*/ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)(PopularCategoryStack, {
                        children: [
                            /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(CustomWrapperBox, {
                                children: /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(CustomSkeleton, {
                                    width: 240,
                                    variant: "rounded",
                                    animation: false,
                                    height: 260
                                })
                            }),
                            /*#__PURE__*/ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)(CustomWrapperStack, {
                                direction: "row",
                                flexWrap: "wrap",
                                children: [
                                    /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(CustomWrapperBox, {
                                        children: /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(CustomSkeleton, {
                                            width: tabScreen ? "100%" : 240,
                                            variant: "rounded",
                                            animation: false,
                                            height: tabScreen ? 400 : 260
                                        })
                                    }),
                                    Array(10).fill().map((_, i)=>/*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_mui_material__WEBPACK_IMPORTED_MODULE_1__.Box, {
                                            sx: {
                                                width: {
                                                    md: "25%"
                                                },
                                                padding: "5px"
                                            },
                                            children: /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(CustomSkeleton, {
                                                width: "100%",
                                                variant: "rounded",
                                                animation: false,
                                                height: 80
                                            })
                                        }, i)).slice(1, 9)
                                ]
                            })
                        ]
                    }) : data?.length > 0 && /*#__PURE__*/ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)(PopularCategoryStack, {
                        children: [
                            /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(CustomWrapperBox, {
                                children: /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_BrandCard__WEBPACK_IMPORTED_MODULE_15__/* ["default"] */ .Z, {
                                    name: data[0].name,
                                    image: data[0].image_full_url,
                                    stock: data[0].items_count,
                                    horizontal: true,
                                    id: data[0].id,
                                    baseUrl: baseUrl,
                                    items_count: data[0].items_count
                                })
                            }),
                            /*#__PURE__*/ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)(CustomWrapperStack, {
                                datalength: data?.length,
                                direction: "row",
                                flexWrap: "wrap",
                                children: [
                                    /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(CustomWrapperBox, {
                                        children: /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_BrandCard__WEBPACK_IMPORTED_MODULE_15__/* ["default"] */ .Z, {
                                            name: data[0].name,
                                            image: data[0].image_full_url,
                                            stock: data[0].items_count,
                                            horizontal: true,
                                            id: data[0].id,
                                            baseUrl: baseUrl,
                                            items_count: data[0].items_count
                                        })
                                    }),
                                    data?.map((item, i)=>/*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_mui_material__WEBPACK_IMPORTED_MODULE_1__.Box, {
                                            sx: {
                                                width: {
                                                    md: "25%"
                                                },
                                                padding: "5px"
                                            },
                                            children: /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_BrandCard__WEBPACK_IMPORTED_MODULE_15__/* ["default"] */ .Z, {
                                                name: item?.name,
                                                image: item?.image_full_url,
                                                stock: item?.items_count,
                                                id: item?.id,
                                                baseUrl: baseUrl,
                                                items_count: item?.items_count
                                            })
                                        }, item?.id)).slice(1, 9)
                                ]
                            })
                        ]
                    })
                })
            })
        ]
    });
};
const CustomBrandCard = _emotion_styled__WEBPACK_IMPORTED_MODULE_7___default()(_mui_material__WEBPACK_IMPORTED_MODULE_1__.Box)(({ theme  })=>({
        borderRadius: "10px",
        padding: "10px",
        background: theme.palette.background.default,
        border: `1px solid ${theme.palette.divider}`,
        transition: "all ease .3s",
        ":hover": {
            boxShadow: theme.shadows[14]
        },
        [theme.breakpoints.up("xl")]: {
            ".brand-card-image": {
                maxWidth: "100px",
                marginRight: "5px"
            }
        }
    }));
const PopularCategoryStack = _emotion_styled__WEBPACK_IMPORTED_MODULE_7___default()(_mui_material__WEBPACK_IMPORTED_MODULE_1__.Stack)(({ theme  })=>({
        flexDirection: "row",
        gap: 1,
        ".MuiBox-root:first-of-type": {
            [theme.breakpoints.down("md")]: {
                display: "none"
            },
            ":hover": {
                boxShadow: theme.shadows[18]
            }
        }
    }));
const CustomWrapperBox = _emotion_styled__WEBPACK_IMPORTED_MODULE_7___default()(_mui_material__WEBPACK_IMPORTED_MODULE_1__.Box)(({ theme  })=>({
        width: {
            xs: "100%"
        },
        maxWidth: {
            lg: "200px",
            xl: "270px"
        },
        background: theme.palette.background.paper,
        ":hover": {
            boxShadow: theme.shadows[4]
        },
        borderRadius: "5px",
        [theme.breakpoints.up("xs")]: {
            padding: "17px 35px 22px"
        },
        [theme.breakpoints.up("md")]: {
            padding: "15px 20px 20px",
            boxShadow: theme.shadows[3]
        },
        [theme.breakpoints.up("xl")]: {
            padding: "17px 35px 22px"
        }
    }));
const CustomWrapperStack = _emotion_styled__WEBPACK_IMPORTED_MODULE_7___default()(_mui_material__WEBPACK_IMPORTED_MODULE_1__.Stack)(({ theme , datalength  })=>({
        width: "575px",
        flexGrow: "1",
        borderRadius: "5px",
        position: "relative",
        ".MuiBox-root:first-of-type": {
            display: "none"
        },
        // rowGap: "24px",
        alignItems: "center",
        background: theme.palette.background.paper,
        boxShadow: theme.shadows[3],
        [theme.breakpoints.up("xs")]: {
            padding: "20px 15px"
        },
        [theme.breakpoints.up("md")]: {
            padding: "20px 5px",
            "&::before": {
                position: "absolute",
                content: "''",
                left: "0",
                top: "50%",
                height: "1px",
                width: "100%",
                opacity: datalength > 4 ? "1" : "0",
                backgroundColor: (0,_mui_material__WEBPACK_IMPORTED_MODULE_1__.alpha)(theme.palette.neutral[400], 0.2)
            },
            ":hover": {
                boxShadow: theme.shadows[4]
            }
        },
        [theme.breakpoints.up("xl")]: {
            padding: "45px 30px"
        },
        [theme.breakpoints.down("md")]: {
            display: "grid",
            gridTemplateColumns: "1fr 1fr",
            width: "100%",
            gap: ".5rem",
            "> .MuiBox-root": {
                // border: "1px solid #ddd",
                borderRadius: ".25rem"
            },
            ".MuiBox-root:first-of-type": {
                display: "flex",
                gridRow: "span 4",
                justifyContent: "center",
                padding: ".25rem",
                img: {
                    maxWidth: "80px"
                }
            }
        }
    }));
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (Brands);

__webpack_async_result__();
} catch(e) { __webpack_async_result__(e); } });

/***/ }),

/***/ 51829:
/***/ ((module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.a(module, async (__webpack_handle_async_dependencies__, __webpack_async_result__) => { try {
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Z": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(20997);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _mui_material__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(65692);
/* harmony import */ var _mui_material__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_mui_material__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(580);
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var react_i18next__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(57987);
var __webpack_async_dependencies__ = __webpack_handle_async_dependencies__([react_i18next__WEBPACK_IMPORTED_MODULE_3__]);
react_i18next__WEBPACK_IMPORTED_MODULE_3__ = (__webpack_async_dependencies__.then ? (await __webpack_async_dependencies__)() : __webpack_async_dependencies__)[0];




const H2 = (props)=>{
    const { text , textAlign , ...rest } = props;
    const { t  } = (0,react_i18next__WEBPACK_IMPORTED_MODULE_3__.useTranslation)();
    const theme = (0,_mui_material__WEBPACK_IMPORTED_MODULE_1__.useTheme)();
    const isSmall = (0,_mui_material__WEBPACK_IMPORTED_MODULE_1__.useMediaQuery)(theme.breakpoints.down("sm"));
    return /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_mui_material__WEBPACK_IMPORTED_MODULE_1__.Typography, {
        textAlign: textAlign ? textAlign : "center",
        variant: isSmall ? "subtitle1" : "h5",
        textTransform: "capitalize",
        ...rest,
        children: t(text)
    });
};
H2.propTypes = {
    text: (prop_types__WEBPACK_IMPORTED_MODULE_2___default().string.isRequired)
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (H2);

__webpack_async_result__();
} catch(e) { __webpack_async_result__(e); } });

/***/ }),

/***/ 72983:
/***/ ((module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.a(module, async (__webpack_handle_async_dependencies__, __webpack_async_result__) => { try {
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Z": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(20997);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _mui_icons_material_KeyboardArrowDown__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(64845);
/* harmony import */ var _mui_icons_material_KeyboardArrowDown__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_mui_icons_material_KeyboardArrowDown__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _mui_icons_material_KeyboardArrowUp__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(99881);
/* harmony import */ var _mui_icons_material_KeyboardArrowUp__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_mui_icons_material_KeyboardArrowUp__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _mui_material__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(65692);
/* harmony import */ var _mui_material__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(_mui_material__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(16689);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_4__);
/* harmony import */ var react_i18next__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(57987);
/* harmony import */ var _components_CustomImageContainer__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(58861);
/* harmony import */ var _assets_sort_png__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(6189);
var __webpack_async_dependencies__ = __webpack_handle_async_dependencies__([react_i18next__WEBPACK_IMPORTED_MODULE_5__]);
react_i18next__WEBPACK_IMPORTED_MODULE_5__ = (__webpack_async_dependencies__.then ? (await __webpack_async_dependencies__)() : __webpack_async_dependencies__)[0];








const Wrapper = (0,_mui_material__WEBPACK_IMPORTED_MODULE_3__.styled)(_mui_material__WEBPACK_IMPORTED_MODULE_3__.Button)(({ theme , border  })=>({
        border: border === "true" && `1px solid ${theme.palette.neutral[400]}`,
        borderRadius: "5px",
        padding: "7px 16px"
    }));
const AtoZ = ({ handleSortBy , sortBy  })=>{
    const [anchorEl, setAnchorEl] = react__WEBPACK_IMPORTED_MODULE_4___default().useState(null);
    const { t  } = (0,react_i18next__WEBPACK_IMPORTED_MODULE_5__.useTranslation)();
    const handleClick = (event)=>{
        setAnchorEl(event.currentTarget);
    };
    const handleClose = ()=>{
        setAnchorEl(null);
    };
    const handleSelect = (value)=>{
        handleSortBy?.(value);
        setAnchorEl(null);
    };
    const open = Boolean(anchorEl);
    const id = open ? "simple-popover" : undefined;
    const getContent = (type, showArrow)=>{
        let text;
        switch(type){
            case "AtoZ":
                text = t("Sort by : A to Z");
                break;
            case "ZtoA":
                text = t("Sort by : Z to A");
                break;
            default:
                text = t("Sort by : Default");
        }
        return /*#__PURE__*/ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)(_mui_material__WEBPACK_IMPORTED_MODULE_3__.Stack, {
            direction: "row",
            alignItems: "center",
            justifyContent: "center",
            spacing: 2,
            children: [
                /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_components_CustomImageContainer__WEBPACK_IMPORTED_MODULE_6__/* ["default"] */ .Z, {
                    src: _assets_sort_png__WEBPACK_IMPORTED_MODULE_7__/* ["default"].src */ .Z.src,
                    height: "12px",
                    width: "12px",
                    objectfit: "contain"
                }),
                /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_mui_material__WEBPACK_IMPORTED_MODULE_3__.Typography, {
                    fontSize: "13px",
                    sx: {
                        color: (theme)=>theme.palette.neutral[600]
                    },
                    children: text
                }),
                showArrow === "true" && /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.Fragment, {
                    children: open ? /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx((_mui_icons_material_KeyboardArrowUp__WEBPACK_IMPORTED_MODULE_2___default()), {
                        sx: {
                            color: (theme)=>theme.palette.text.secondary
                        }
                    }) : /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx((_mui_icons_material_KeyboardArrowDown__WEBPACK_IMPORTED_MODULE_1___default()), {
                        sx: {
                            color: (theme)=>theme.palette.text.secondary
                        }
                    })
                })
            ]
        });
    };
    return /*#__PURE__*/ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)("div", {
        children: [
            /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(Wrapper, {
                border: "true",
                onClick: handleClick,
                children: getContent(sortBy, "true")
            }),
            /*#__PURE__*/ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)(_mui_material__WEBPACK_IMPORTED_MODULE_3__.Popover, {
                fullWidth: true,
                id: id,
                open: open,
                anchorEl: anchorEl,
                onClose: handleClose,
                anchorOrigin: {
                    vertical: "bottom",
                    horizontal: "left"
                },
                PaperProps: {
                    style: {
                        width: anchorEl?.clientWidth || "auto"
                    }
                },
                children: [
                    /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(Wrapper, {
                        onClick: ()=>handleSelect("AtoZ"),
                        children: getContent("AtoZ", "false")
                    }),
                    /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(Wrapper, {
                        onClick: ()=>handleSelect("ZtoA"),
                        children: getContent("ZtoA", "false")
                    }),
                    /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(Wrapper, {
                        onClick: ()=>handleSelect("default"),
                        children: getContent("default", "false")
                    })
                ]
            })
        ]
    });
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (AtoZ);

__webpack_async_result__();
} catch(e) { __webpack_async_result__(e); } });

/***/ })

};
;